require_relative '../rspec_helper'
require_relative '../../pages/community_care/community_Care_PageObject'
require 'rubygems'
require_relative '../../module/DriverUtility'
require_relative '../../pages/landing_appointments'

describe '[Defect: VAR-12881 - CC - Facility Locator does not open in new tab when navigating from "Get Emergency Help" window;]' do

  include DriverUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @cc_po = CommunityCare_PageObject.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    @cc_po.common.loginEndsOnHome(pw_redacted)
  end

  after(:all) do
    quitDriver
  end

  context "VAR-12881 - CC - Facility Locator does not open in new tab when navigating from 'Get Emergency Help' window;" do

    it "should verify Content of Crisis Banner Modal" do
      @landing_appointments.get_emergency_btn
      actual_content = @landing_appointments.crisis_modal_content_element.text.split("\n")
      expected_content = [\
      "Get Emergency Help",
      "If this is a medical emergency, please call 911.",
      "Dial 9 1 1 from your mobile device",
      "If you are in crisis or having thoughts of suicide, call the Veterans Crisis Hotline at 1-800-273-8255 and press 1.",
      "For urgent matters related to an appointment within the next 72 hours, please contact your VA Facility.",
      "OK"
      ]
      compareContents(expected_content, actual_content)
    end

    it "verify Confirmation Modal content" do
      @landing_appointments.clickOnCrisisBannerLink
      actual_content = @cc_po.modal.leaveConfirm_element.text.split("\n")
      expected_content = [\
      "Confirmation",
      "You are about to leave the VA Appointments app. Select CONTINUE to proceed to the link information selected, or select RETURN to return to the VA Appointments app.",
      "Continue Return"
      ]
      compareContents(expected_content, actual_content)
    end


    it "should switch to new tab and verify the Tab's title" do
      @cc_po.modal.continue
      switchWindowToWindowHandleLast
      getCurrentURL
      expect(getTitle).to eq("Veterans Health Administration - Locations")
    end

    it "should navigate back to previous tab and close modal" do
      switchWindowToWindowHandleFirst
      @driver.execute_script("$(arguments[0]).click();", @landing_appointments.oK_btn)
      @landing_appointments.appointment_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing_appointments.has_expected_title?).to eq(true)
    end

  end


end


